#!/bin/sh

echo "Generating directscheduling.mdws.generatedwsdl SOAP client..."

function gen_client () {
    typeset generatedDir="../src/main/java/com/agilex/healthcare/directscheduling/mdws/generatedwsdl/$1"
    if [[ -d $generatedDir ]] ; then
        echo "Deleting $generatedDir"
        rm -rf $generatedDir
    fi

    echo $2.wsdl
    wsimport -extension -Xnocompile -XadditionalHeaders -B-XautoNameResolution -s ../src/main/java \
        -p com.agilex.healthcare.directscheduling.mdws.generatedwsdl.$1 -keep \
        -wsdllocation META-INF/$2.wsdl "./$2.wsdl"
}

gen_client "schedulingservice" "SchedulingSvc"
